/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.DinosaurToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WelcomeToEffect
extends OneShotEffect {
    WelcomeToEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 3/3 green Dinosaur creature token with trample. It gains haste until end of turn.";
    }

    private WelcomeToEffect(WelcomeToEffect effect) {
        super((OneShotEffect)effect);
    }

    public WelcomeToEffect copy() {
        return new WelcomeToEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenEffect effect = new CreateTokenEffect((Token)new DinosaurToken());
        effect.apply(game, source);
        effect.getLastAddedTokenIds().forEach(permanentID -> {
            GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
            continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(permanentID));
            game.addEffect((ContinuousEffect)continuousEffect, source);
        });
        return true;
    }
}

