/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class WellLaidPlansPreventionEffect
extends PreventionEffectImpl {
    WellLaidPlansPreventionEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false, false);
        this.staticText = "Prevent all damage that would be dealt to a creature by another creature if they share a color";
    }

    private WellLaidPlansPreventionEffect(WellLaidPlansPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public WellLaidPlansPreventionEffect copy() {
        return new WellLaidPlansPreventionEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGE_PERMANENT) {
            return false;
        }
        Permanent attacker = game.getPermanentOrLKIBattlefield(event.getSourceId());
        Permanent damaged = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (attacker == null || damaged == null || !attacker.isCreature(game) || !damaged.isCreature(game)) {
            return false;
        }
        return !attacker.getColor(game).intersection(damaged.getColor(game)).isColorless();
    }
}

