/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WerewolfPackLeaderEffect
extends ContinuousEffectImpl {
    WerewolfPackLeaderEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, {this} has base power and toughness 5/3, gains trample, and isn't a Human";
    }

    private WerewolfPackLeaderEffect(WerewolfPackLeaderEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public WerewolfPackLeaderEffect copy() {
        return new WerewolfPackLeaderEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeSubType(game, SubType.HUMAN);
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility((Ability)TrampleAbility.getInstance(), source.getSourceId(), game);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(5);
                permanent.getToughness().setModifiedBaseValue(3);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

