/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.abilities.effects.keyword.InvestigateTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WernogRidersChaplainEffect
extends OneShotEffect {
    WernogRidersChaplainEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent may investigate. Each opponent who doesn't loses 1 life. You investigate X times, where X is one plus the number of opponents who investigated this way";
    }

    private WernogRidersChaplainEffect(WernogRidersChaplainEffect effect) {
        super((OneShotEffect)effect);
    }

    public WernogRidersChaplainEffect copy() {
        return new WernogRidersChaplainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = 1;
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            if (opponent.chooseUse(this.outcome, "Investigate?", source, game)) {
                ++count;
                new InvestigateTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(playerId)).apply(game, source);
                continue;
            }
            opponent.loseLife(1, game, source, false);
        }
        new InvestigateEffect(count).apply(game, source);
        return true;
    }
}

