/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class WheelOfMisfortuneEffect
extends OneShotEffect {
    WheelOfMisfortuneEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player secretly chooses a number 0 or greater, then all players reveal those numbers simultaneously and determine the highest and lowest numbers revealed this way. {this} deals damage equal to the highest number to each player who chose that number. Each player who didn't choose the lowest number discards their hand, then draws seven cards.";
    }

    private WheelOfMisfortuneEffect(WheelOfMisfortuneEffect effect) {
        super((OneShotEffect)effect);
    }

    public WheelOfMisfortuneEffect copy() {
        return new WheelOfMisfortuneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        HashMap<UUID, Integer> playerMap = new HashMap<UUID, Integer>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            playerMap.put(playerId, player.getAmount(0, 1000, "Choose a number", source, game));
        }
        for (Map.Entry entry : playerMap.entrySet()) {
            player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            game.informPlayers(player.getLogName() + " chose " + entry.getValue());
        }
        int maxValue = playerMap.values().stream().mapToInt(x -> x).max().orElse(0);
        game.informPlayers("The highest number chosen was " + maxValue);
        int minValue = playerMap.values().stream().mapToInt(x -> x).min().orElse(0);
        game.informPlayers("The lowest number chosen was " + minValue);
        for (Map.Entry entry : playerMap.entrySet()) {
            Player player2 = game.getPlayer((UUID)entry.getKey());
            if (player2 == null) continue;
            if ((Integer)entry.getValue() == maxValue) {
                player2.damage(maxValue, source.getSourceId(), source, game);
            }
            if ((Integer)entry.getValue() == minValue) continue;
            player2.discard(player2.getHand(), false, source, game);
            player2.drawCards(7, source, game);
        }
        return true;
    }
}

