/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.w.TargetSecondPilePermanent;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;

class WhimsOfTheFateEffect
extends OneShotEffect {
    public WhimsOfTheFateEffect() {
        super(Outcome.Detriment);
        this.staticText = "Starting with you, each player separates all permanents they control into three piles. Then each player chooses one of their piles at random and sacrifices those permanents.";
    }

    private WhimsOfTheFateEffect(WhimsOfTheFateEffect effect) {
        super((OneShotEffect)effect);
    }

    public WhimsOfTheFateEffect copy() {
        return new WhimsOfTheFateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            LinkedHashMap playerPermanents = new LinkedHashMap();
            PlayerList playerList = game.getState().getPlayerList().copy();
            while (!((UUID)playerList.get()).equals(source.getControllerId()) && controller.canRespond()) {
                playerList.getNext();
            }
            Player currentPlayer = game.getPlayer((UUID)playerList.get());
            UUID firstNextPlayer = null;
            while (!this.getNextPlayerInDirection(true, playerList, game).equals(firstNextPlayer) && controller.canRespond()) {
                Player nextPlayer = game.getPlayer((UUID)playerList.get());
                if (nextPlayer == null) {
                    return false;
                }
                if (firstNextPlayer == null) {
                    firstNextPlayer = nextPlayer.getId();
                }
                if (!nextPlayer.canRespond()) continue;
                if (currentPlayer != null && game.getState().getPlayersInRange(controller.getId(), game).contains((Object)currentPlayer.getId())) {
                    int i;
                    HashMap playerPiles = new HashMap();
                    for (i = 1; i < 4; ++i) {
                        playerPiles.put(i, new LinkedHashSet());
                    }
                    playerPermanents.put(currentPlayer.getId(), playerPiles);
                    for (i = 1; i < 3; ++i) {
                        FilterPermanent filter = new FilterPermanent("the permanents for the " + (i == 1 ? "first " : "second ") + "pile");
                        filter.add((Predicate)new ControllerIdPredicate(currentPlayer.getId()));
                        Object target = i == 1 ? new TargetPermanent(0, Integer.MAX_VALUE, filter, true) : new TargetSecondPilePermanent((Set)playerPiles.get(1), filter);
                        currentPlayer.chooseTarget(this.outcome, (Target)target, source, game);
                        StringBuilder message = new StringBuilder(currentPlayer.getLogName()).append(" pile ").append(i).append(": ");
                        if (target.getTargets().isEmpty()) {
                            message.append(" (empty)");
                        } else {
                            for (UUID permanentId : target.getTargets()) {
                                Permanent permanent = game.getPermanent(permanentId);
                                if (permanent == null) continue;
                                message.append(permanent.getName()).append(' ');
                            }
                        }
                        game.informPlayers(message.toString());
                        ((Set)playerPiles.get(i)).addAll(target.getTargets());
                    }
                    StringBuilder message = new StringBuilder(currentPlayer.getLogName()).append(" pile 3: ");
                    for (Permanent permanent : game.getBattlefield().getAllActivePermanents(currentPlayer.getId())) {
                        if (((Set)playerPiles.get(1)).contains(permanent.getId()) || ((Set)playerPiles.get(2)).contains(permanent.getId())) continue;
                        ((Set)playerPiles.get(3)).add(permanent.getId());
                        message.append(permanent.getName()).append(' ');
                    }
                    if (((Set)playerPiles.get(3)).isEmpty()) {
                        message.append(" (empty)");
                    }
                    game.informPlayers(message.toString());
                }
                currentPlayer = nextPlayer;
            }
            for (Map.Entry playerPiles : playerPermanents.entrySet()) {
                Player player = game.getPlayer((UUID)playerPiles.getKey());
                if (player == null) continue;
                int sacrificePile = RandomUtil.nextInt((int)3) + 1;
                game.informPlayers(player.getLogName() + " sacrifices pile number " + sacrificePile);
                for (UUID permanentId : (Set)((Map)playerPiles.getValue()).get(sacrificePile)) {
                    Permanent permanent = game.getPermanent(permanentId);
                    if (permanent == null) continue;
                    permanent.sacrifice(source, game);
                }
            }
            return true;
        }
        return false;
    }

    private UUID getNextPlayerInDirection(boolean left, PlayerList playerList, Game game) {
        UUID nextPlayerId = left ? (UUID)playerList.getNext() : (UUID)playerList.getPrevious();
        return nextPlayerId;
    }
}

