/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class WhisperingSnitchWatcher
extends Watcher {
    private final Map<UUID, Integer> timesSurveiled = new HashMap<UUID, Integer>();

    public WhisperingSnitchWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SURVEILED) {
            this.timesSurveiled.put(event.getPlayerId(), this.getTimesSurveiled(event.getPlayerId()) + 1);
        }
    }

    public void reset() {
        super.reset();
        this.timesSurveiled.clear();
    }

    public int getTimesSurveiled(UUID playerId) {
        return this.timesSurveiled.getOrDefault(playerId, 0);
    }
}

