/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class WhiteGloveGourmandWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> diedThisTurn = new HashMap<UUID, Set<MageObjectReference>>();

    WhiteGloveGourmandWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zce = (ZoneChangeEvent)event;
        if (!zce.isDiesEvent()) {
            return;
        }
        Permanent permanent = zce.getTarget();
        if (permanent != null && permanent.hasSubtype(SubType.HUMAN, game)) {
            this.diedThisTurn.computeIfAbsent(event.getPlayerId(), k -> new HashSet());
            this.diedThisTurn.get(event.getPlayerId()).add(new MageObjectReference((MageObject)permanent, game));
        }
    }

    public void reset() {
        super.reset();
        this.diedThisTurn.clear();
    }

    static boolean checkCondition(UUID playerId, MageObjectReference morSource, Game game) {
        WhiteGloveGourmandWatcher watcher = (WhiteGloveGourmandWatcher)game.getState().getWatcher(WhiteGloveGourmandWatcher.class);
        return watcher != null && watcher.diedThisTurn.getOrDefault(playerId, Collections.emptySet()).stream().anyMatch(mor -> !mor.equals((Object)morSource));
    }
}

