/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.PhyrexianMiteToken;
import mage.util.CardUtil;

class WhiteSunsTwilightEffect
extends OneShotEffect {
    WhiteSunsTwilightEffect() {
        super(Outcome.Benefit);
        this.staticText = "create X 1/1 colorless Phyrexian Mite artifact creature tokens with toxic 1 and \"This creature can't block.\" If X is 5 or more, destroy all other creatures";
    }

    private WhiteSunsTwilightEffect(WhiteSunsTwilightEffect effect) {
        super((OneShotEffect)effect);
    }

    public WhiteSunsTwilightEffect copy() {
        return new WhiteSunsTwilightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        PhyrexianMiteToken token = new PhyrexianMiteToken();
        token.putOntoBattlefield(xValue, game, source);
        if (xValue < 5) {
            return true;
        }
        List tokenIds = token.getLastAddedTokenIds();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getSourceId(), game)) {
            if (tokenIds.contains(permanent.getId())) continue;
            permanent.destroy(source, game);
        }
        return true;
    }
}

