/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SnailToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class WickTheWhorledMindEffect
extends OneShotEffect {
    WickTheWhorledMindEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 black Snail creature token if you don't control a Snail. Otherwise, put a +1/+1 counter on a Snail you control";
    }

    private WickTheWhorledMindEffect(WickTheWhorledMindEffect effect) {
        super((OneShotEffect)effect);
    }

    public WickTheWhorledMindEffect copy() {
        return new WickTheWhorledMindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterControlledPermanent filter = new FilterControlledPermanent(SubType.SNAIL, "Snail");
        if (game.getBattlefield().contains((FilterPermanent)filter, source.getControllerId(), source, game, 1)) {
            TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
            target.withNotTarget(true);
            if (!target.canChoose(source.getControllerId(), source, game)) {
                return false;
            }
            controller.choose(Outcome.BoostCreature, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
                return true;
            }
            return false;
        }
        return new SnailToken().putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

