/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.AmassEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WidespreadBrutalityEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    WidespreadBrutalityEffect() {
        super(Outcome.Benefit);
        this.staticText = "amass Zombies 2, then the Army you amassed deals damage equal to its power to each non-Army creature. <i>(To amass 2, put two +1/+1 counters on an Army you control. It's also a Zombie. If you don't control one, create a 0/0 black Zombie Army creature token first.)</i>";
    }

    private WidespreadBrutalityEffect(WidespreadBrutalityEffect effect) {
        super((OneShotEffect)effect);
    }

    public WidespreadBrutalityEffect copy() {
        return new WidespreadBrutalityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent amassedArmy = AmassEffect.doAmass((int)2, (SubType)SubType.ZOMBIE, (Game)game, (Ability)source);
        if (amassedArmy == null) {
            return false;
        }
        game.processAction();
        int power = amassedArmy.getPower().getValue();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            permanent.damage(power, amassedArmy.getId(), source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.ARMY.getPredicate()));
    }
}

