/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class WidespreadPanicEffect
extends OneShotEffect {
    WidespreadPanicEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player puts a card from their hand on top of their library";
    }

    private WidespreadPanicEffect(WidespreadPanicEffect effect) {
        super((OneShotEffect)effect);
    }

    public WidespreadPanicEffect copy() {
        return new WidespreadPanicEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player shuffler = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (shuffler != null) {
            if (!shuffler.getHand().isEmpty()) {
                TargetCardInHand target = new TargetCardInHand().withChooseHint("to put on top of your library");
                shuffler.choose(Outcome.Detriment, (Target)target, source, game);
                Card card = shuffler.getHand().get(target.getFirstTarget(), game);
                if (card != null) {
                    shuffler.moveCardToLibraryWithInfo(card, source, game, Zone.HAND, true, false);
                }
            }
            return true;
        }
        return false;
    }
}

