/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class WildMagicSorcererWatcher
extends Watcher {
    private final Map<UUID, MageObjectReference> playerMap = new HashMap<UUID, MageObjectReference>();

    WildMagicSorcererWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.CAST_SPELL || event.getZone() != Zone.EXILED) {
            return;
        }
        Spell spell = game.getSpell(event.getSourceId());
        if (spell == null) {
            return;
        }
        this.playerMap.computeIfAbsent(event.getPlayerId(), x -> new MageObjectReference((MageObject)spell.getMainCard(), game));
    }

    public void reset() {
        this.playerMap.clear();
        super.reset();
    }

    static boolean checkSpell(StackObject stackObject, Game game) {
        if (stackObject.isCopy() || !(stackObject instanceof Spell)) {
            return false;
        }
        WildMagicSorcererWatcher watcher = (WildMagicSorcererWatcher)game.getState().getWatcher(WildMagicSorcererWatcher.class);
        return watcher.playerMap.containsKey(stackObject.getControllerId()) && watcher.playerMap.get(stackObject.getControllerId()).refersTo((MageObject)((Spell)stackObject).getMainCard(), game);
    }
}

