/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class WindfallEffect
extends OneShotEffect {
    WindfallEffect() {
        super(Outcome.Discard);
        this.staticText = "Each player discards their hand, then draws cards equal to the greatest number of cards a player discarded this way.";
    }

    private WindfallEffect(WindfallEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        int maxDiscarded = 0;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            int discarded;
            player = game.getPlayer(playerId);
            if (player == null || (discarded = player.discard(player.getHand(), false, source, game).size()) <= maxDiscarded) continue;
            maxDiscarded = discarded;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            player.drawCards(maxDiscarded, source, game);
        }
        return true;
    }

    public WindfallEffect copy() {
        return new WindfallEffect(this);
    }
}

