/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.CleaveAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;

public final class WingedPortent
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();
    private static final DynamicValue xValue1;
    private static final DynamicValue xValue2;
    private static final Hint hint1;
    private static final Hint hint2;

    public WingedPortent(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{U}{U}");
        this.addAbility(new CleaveAbility((Card)this, (Effect)new DrawCardSourceControllerEffect(xValue1), "{4}{G}{U}").addHint(hint1));
        this.getSpellAbility().addEffect((Effect)new DrawCardSourceControllerEffect(xValue2).setText("draw a card for each creature [with flying] you control"));
        this.getSpellAbility().addHint(hint2);
    }

    private WingedPortent(WingedPortent card) {
        super((CardImpl)card);
    }

    public WingedPortent copy() {
        return new WingedPortent(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlyingAbility.class));
        xValue1 = new PermanentsOnBattlefieldCount((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE);
        xValue2 = new PermanentsOnBattlefieldCount(filter);
        hint1 = new ValueHint("Creatures you control", xValue1);
        hint2 = new ValueHint("Creatures you control with flying", xValue2);
    }
}

