/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WinnowEffect
extends DestroyTargetEffect {
    WinnowEffect() {
        this.staticText = "Destroy target nonland permanent if another permanent with the same name is on the battlefield";
    }

    private WinnowEffect(WinnowEffect effect) {
        super((DestroyTargetEffect)effect);
    }

    public WinnowEffect copy() {
        return new WinnowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target != null) {
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)new NamePredicate(target.getName()));
            if (new PermanentsOnBattlefieldCount(filter).calculate(game, source, (Effect)this) > 1) {
                super.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

