/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WinterBlastEffect
extends OneShotEffect {
    WinterBlastEffect() {
        super(Outcome.Benefit);
        this.staticText = "Tap X target creatures. {this} deals 2 damage to each of those creatures with flying.";
    }

    private WinterBlastEffect(WinterBlastEffect effect) {
        super((OneShotEffect)effect);
    }

    public WinterBlastEffect copy() {
        return new WinterBlastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int affectedTargets = 0;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            permanent.tap(source, game);
            if (permanent.getAbilities().contains((Ability)FlyingAbility.getInstance())) {
                permanent.damage(2, source.getSourceId(), source, game, false, true);
            }
            ++affectedTargets;
        }
        return affectedTargets > 0;
    }
}

