/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionUntapNotMoreThanEffect;
import mage.constants.Duration;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WinterOrbEffect
extends RestrictionUntapNotMoreThanEffect {
    private static final FilterControlledPermanent filter = new FilterControlledLandPermanent();

    public WinterOrbEffect() {
        super(Duration.WhileOnBattlefield, 1, filter);
        this.staticText = "As long as {this} is untapped, players can't untap more than one land during their untap steps";
    }

    private WinterOrbEffect(WinterOrbEffect effect) {
        super((RestrictionUntapNotMoreThanEffect)effect);
    }

    public boolean applies(Player player, Ability source, Game game) {
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        return sourceObject != null && !sourceObject.isTapped();
    }

    public WinterOrbEffect copy() {
        return new WinterOrbEffect(this);
    }
}

