/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WisecrackEffect
extends OneShotEffect {
    WisecrackEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature deals damage equal to its power to itself. If that creature is attacking, {this} deals 2 damage to that creature's controller";
    }

    private WisecrackEffect(WisecrackEffect effect) {
        super((OneShotEffect)effect);
    }

    public WisecrackEffect copy() {
        return new WisecrackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        permanent.damage(permanent.getPower().getValue(), permanent.getId(), source, game);
        if (permanent.isAttacking()) {
            Optional.ofNullable(permanent).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(player -> player.damage(2, source, game));
        }
        return true;
    }
}

