/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.w.WishPlayFromSideboardEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class WishEffect
extends OneShotEffect {
    WishEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may play a card you own from outside the game this turn";
    }

    private WishEffect(WishEffect effect) {
        super((OneShotEffect)effect);
    }

    public WishEffect copy() {
        return new WishEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && !controller.getSideboard().isEmpty()) {
            controller.lookAtCards(source, "Sideboard", controller.getSideboard(), game);
            game.addEffect((ContinuousEffect)new WishPlayFromSideboardEffect(), source);
            return true;
        }
        return false;
    }
}

