/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.FoodToken;
import mage.game.permanent.token.Token;

class WitchsOvenEffect
extends OneShotEffect {
    private static final Effect effect1 = new CreateTokenEffect((Token)new FoodToken(), 1);
    private static final Effect effect2 = new CreateTokenEffect((Token)new FoodToken(), 2);

    WitchsOvenEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create a Food token. If the sacrificed creature's toughness was 4 or greater, create two Food tokens instead";
    }

    private WitchsOvenEffect(WitchsOvenEffect effect) {
        super((OneShotEffect)effect);
    }

    public WitchsOvenEffect copy() {
        return new WitchsOvenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean big = source.getCosts().stream().filter(SacrificeTargetCost.class::isInstance).map(SacrificeTargetCost.class::cast).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).map(MageObject::getToughness).mapToInt(MageInt::getValue).anyMatch(i -> i > 3);
        if (big) {
            return effect2.apply(game, source);
        }
        return effect1.apply(game, source);
    }
}

