/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class WitheringGazeEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Forest or green card");

    public WitheringGazeEffect() {
        super(Outcome.DrawCard);
        this.staticText = "You draw a card for each Forest and green card in it";
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getTargets().getFirstTarget());
        if (controller != null && targetPlayer != null) {
            int count = 0;
            for (Card card : targetPlayer.getHand().getCards(game)) {
                if (!filter.match(card, game)) continue;
                ++count;
            }
            controller.drawCards(count, source, game);
            return true;
        }
        return false;
    }

    private WitheringGazeEffect(WitheringGazeEffect effect) {
        super((OneShotEffect)effect);
    }

    public WitheringGazeEffect copy() {
        return new WitheringGazeEffect(this);
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.FOREST.getPredicate(), (Predicate)new ColorPredicate(ObjectColor.GREEN)));
    }
}

