/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class WoebringerDemonEffect
extends OneShotEffect {
    WoebringerDemonEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player sacrifices a creature of their choice. If the player can't, sacrifice {this}";
    }

    private WoebringerDemonEffect(WoebringerDemonEffect effect) {
        super((OneShotEffect)effect);
    }

    public WoebringerDemonEffect copy() {
        return new WoebringerDemonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourceObject;
            TargetSacrifice target;
            Player currentPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (currentPlayer != null && (target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE)).canChoose(currentPlayer.getId(), source, game)) {
                currentPlayer.choose(Outcome.Sacrifice, (Target)target, source, game);
                Permanent permanent = game.getPermanent(target.getFirstTarget());
                if (permanent != null) {
                    permanent.sacrifice(source, game);
                    return true;
                }
            }
            if ((sourceObject = game.getPermanent(source.getSourceId())) != null && sourceObject.getZoneChangeCounter(game) == source.getStackMomentSourceZCC()) {
                sourceObject.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }
}

