/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class WolverineBestThereIsWatcher
extends Watcher {
    private final Set<MageObjectReference> set = new HashSet<MageObjectReference>();

    WolverineBestThereIsWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PERMANENT || event.getTargetId().equals(event.getSourceId())) {
            return;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent != null && permanent.isCreature(game)) {
            this.set.add(new MageObjectReference(event.getSourceId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean check(Ability source, Game game) {
        return ((WolverineBestThereIsWatcher)game.getState().getWatcher(WolverineBestThereIsWatcher.class)).set.stream().anyMatch(mor -> mor.refersTo(source, game));
    }
}

