/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.w.WonderscapeSageReturnCost;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class WonderscapeSageEffect
extends OneShotEffect {
    WonderscapeSageEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw a card. Then discard a card unless that land had a nonbasic land type.";
    }

    private WonderscapeSageEffect(WonderscapeSageEffect effect) {
        super((OneShotEffect)effect);
    }

    public WonderscapeSageEffect copy() {
        return new WonderscapeSageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        if (!CardUtil.castStream((Stream)source.getCosts().stream(), WonderscapeSageReturnCost.class).filter(Objects::nonNull).map(WonderscapeSageReturnCost::getNonBasicLandTypes).flatMap(Collection::stream).distinct().findAny().isPresent()) {
            player.discardOne(false, false, source, game);
        }
        return true;
    }
}

