/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class WoodElementalEffect
extends ReplacementEffectImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("untapped Forests you control");

    public WoodElementalEffect() {
        super(Duration.EndOfGame, Outcome.Sacrifice);
        this.staticText = "sacrifice any number of untapped Forests";
    }

    private WoodElementalEffect(WoodElementalEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WoodElementalEffect copy() {
        return new WoodElementalEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (creature == null || controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)filter);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        controller.choose(Outcome.Detriment, (Target)target, source, game);
        if (target.getTargets().isEmpty()) {
            return false;
        }
        int value = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent targetCreature = game.getPermanent(targetId);
            if (targetCreature == null || !targetCreature.sacrifice(source, game)) continue;
            ++value;
        }
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(value, value, Duration.WhileOnBattlefield), source);
        this.discard();
        return false;
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        filter.add((Predicate)SubType.FOREST.getPredicate());
    }
}

