/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class WordsOfWorshipEffect
extends ReplacementEffectImpl {
    WordsOfWorshipEffect() {
        super(Duration.EndOfTurn, Outcome.Damage);
        this.staticText = "The next time you would draw a card this turn, you gain 5 life instead.";
    }

    private WordsOfWorshipEffect(WordsOfWorshipEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WordsOfWorshipEffect copy() {
        return new WordsOfWorshipEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.gainLife(5, game, source);
            this.used = true;
            this.discard();
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used) {
            return source.isControlledBy(event.getPlayerId());
        }
        return false;
    }
}

