/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.w.WorldslayerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class WorldslayerTriggeredAbility
extends TriggeredAbilityImpl {
    WorldslayerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new WorldslayerEffect(), false);
    }

    private WorldslayerTriggeredAbility(WorldslayerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public WorldslayerTriggeredAbility copy() {
        return new WorldslayerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent p = game.getPermanent(event.getSourceId());
        return damageEvent.isCombatDamage() && p != null && p.getAttachments().contains(this.getSourceId());
    }

    public String getRule() {
        return "Whenever equipped creature deals combat damage to a player, destroy all permanents other than {this}.";
    }
}

