/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.MapToken;
import mage.util.CardUtil;

class WorldwalkerHelmReplacementEffect
extends ReplacementEffectImpl {
    WorldwalkerHelmReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if you would create one or more artifact tokens, instead create those tokens plus an additional Map token";
    }

    private WorldwalkerHelmReplacementEffect(WorldwalkerHelmReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WorldwalkerHelmReplacementEffect copy() {
        return new WorldwalkerHelmReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (!(event instanceof CreateTokenEvent)) {
            return false;
        }
        CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
        if (tokenEvent.getTokens().keySet().stream().noneMatch(MageObject::isArtifact)) {
            return false;
        }
        MapToken mapToken = CardUtil.castStream(tokenEvent.getTokens().keySet().stream(), MapToken.class).findFirst().orElseGet(MapToken::new);
        tokenEvent.getTokens().compute(mapToken, CardUtil::setOrIncrementValue);
        return false;
    }
}

