/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WrathfulRaptorsEffect
extends OneShotEffect {
    WrathfulRaptorsEffect() {
        super(Outcome.Damage);
    }

    private WrathfulRaptorsEffect(WrathfulRaptorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public WrathfulRaptorsEffect copy() {
        return new WrathfulRaptorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent dinosaur = (Permanent)this.getValue("damagedPermanent");
        Integer damage = (Integer)this.getValue("damage");
        if (dinosaur == null || damage == null) {
            return false;
        }
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        Permanent permanent = game.getPermanent(targetId);
        if (permanent != null) {
            return permanent.damage(damage.intValue(), dinosaur.getId(), source, game) > 0;
        }
        Player player = game.getPlayer(targetId);
        if (player != null) {
            return player.damage(damage.intValue(), dinosaur.getId(), source, game) > 0;
        }
        return false;
    }
}

