/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class WrennAndSevenLandEffect
extends OneShotEffect {
    WrennAndSevenLandEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "put any number of land cards from your hand onto the battlefield tapped";
    }

    private WrennAndSevenLandEffect(WrennAndSevenLandEffect effect) {
        super((OneShotEffect)effect);
    }

    public WrennAndSevenLandEffect copy() {
        return new WrennAndSevenLandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) < 1) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_LANDS);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        return player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, true, null);
    }
}

