/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import java.util.Collection;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.common.asthought.CanPlayCardControllerEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.game.Game;
import mage.players.Player;

class XandersPactCastEffect
extends CanPlayCardControllerEffect {
    XandersPactCastEffect(Game game, Card card) {
        super(game, card.getMainCard().getId(), card.getZoneChangeCounter(game), true, Duration.EndOfTurn);
    }

    private XandersPactCastEffect(XandersPactCastEffect effect) {
        super((CanPlayCardControllerEffect)effect);
    }

    public XandersPactCastEffect copy() {
        return new XandersPactCastEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!super.applies(objectId, source, affectedControllerId, game)) {
            return false;
        }
        Card cardToCheck = game.getCard(objectId);
        if (cardToCheck.isLand(game)) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        CostsImpl newCosts = new CostsImpl();
        newCosts.add((Object)new PayLifeCost(cardToCheck.getManaValue()));
        newCosts.addAll((Collection)cardToCheck.getSpellAbility().getCosts());
        controller.setCastSourceIdWithAlternateMana(cardToCheck.getId(), null, (Costs)newCosts, MageIdentifier.XandersPactAlternateCast);
        return true;
    }
}

