/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class XathridDemonEffect
extends OneShotEffect {
    XathridDemonEffect() {
        super(Outcome.Damage);
        this.staticText = "sacrifice a creature other than {this}, then each opponent loses life equal to the sacrificed creature's power. If you can't sacrifice a creature, tap {this} and you lose 7 life";
    }

    private XathridDemonEffect(XathridDemonEffect effect) {
        super((OneShotEffect)effect);
    }

    public XathridDemonEffect copy() {
        return new XathridDemonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            sourcePermanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature other than " + sourcePermanent.getName());
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)filter);
        if (target.canChoose(controller.getId(), source, game)) {
            controller.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                int amount = permanent.getPower().getValue();
                permanent.sacrifice(source, game);
                if (amount > 0) {
                    Set opponents = game.getOpponents(source.getControllerId());
                    for (UUID opponentId : opponents) {
                        Player opponent = game.getPlayer(opponentId);
                        if (opponent == null) continue;
                        opponent.loseLife(amount, game, source, false);
                    }
                }
                return true;
            }
        } else {
            sourcePermanent.tap(source, game);
            controller.loseLife(7, game, source, false);
            return true;
        }
        return false;
    }
}

