/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class XenagosGodOfRevelsEffect
extends OneShotEffect {
    XenagosGodOfRevelsEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "and gets +X/+X until end of turn, where X is that creature's power";
    }

    private XenagosGodOfRevelsEffect(XenagosGodOfRevelsEffect effect) {
        super((OneShotEffect)effect);
    }

    public XenagosGodOfRevelsEffect copy() {
        return new XenagosGodOfRevelsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature == null) {
            return false;
        }
        int power = targetCreature.getPower().getValue();
        game.addEffect(new BoostTargetEffect(power, power, Duration.EndOfTurn).setTargetPointer(this.getTargetPointer().copy()), source);
        return false;
    }
}

