/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.SubLayer;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class XenicPoltergeistEffect
extends ContinuousEffectImpl {
    private static final FilterArtifactPermanent filter = new FilterArtifactPermanent();

    public XenicPoltergeistEffect() {
        super(Duration.Custom, Outcome.BecomeCreature);
        this.staticText = "Until your next upkeep, target noncreature artifact becomes an artifact creature with power and toughness each equal to its mana value";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private XenicPoltergeistEffect(XenicPoltergeistEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public XenicPoltergeistEffect copy() {
        return new XenicPoltergeistEffect(this);
    }

    public boolean isInactive(Ability source, Game game) {
        return game.getPhase().getStep().getType() == PhaseStep.UPKEEP && game.isActivePlayer(source.getControllerId());
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        switch (layer) {
            case TypeChangingEffects_4: {
                UUID permanentId;
                Permanent permanent;
                if (sublayer != SubLayer.NA || (permanent = game.getPermanentOrLKIBattlefield(permanentId = this.getTargetPointer().getFirst(game, source))) == null) break;
                if (!permanent.isArtifact(game)) {
                    permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                }
                if (permanent.isCreature(game)) break;
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                break;
            }
            case PTChangingEffects_7: {
                UUID permanentId;
                Permanent permanent;
                if (sublayer != SubLayer.SetPT_7b || (permanent = game.getPermanentOrLKIBattlefield(permanentId = this.getTargetPointer().getFirst(game, source))) == null) break;
                int manaCost = permanent.getManaValue();
                permanent.getPower().setModifiedBaseValue(manaCost);
                permanent.getToughness().setModifiedBaseValue(manaCost);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.TypeChangingEffects_4;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
    }
}

