/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.counter.DistributeCountersEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanentAmount;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class YannikScavengingSentinelEffect
extends OneShotEffect {
    YannikScavengingSentinelEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile another creature you control until {this} leaves the battlefield. When you do, distribute X +1/+1 counters among any number of target creatures, where X is the exiled creature's power.";
    }

    private YannikScavengingSentinelEffect(YannikScavengingSentinelEffect effect) {
        super((OneShotEffect)effect);
    }

    public YannikScavengingSentinelEffect copy() {
        return new YannikScavengingSentinelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || sourcePermanent == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE_YOU_CONTROL, source.getControllerId(), source, game) < 1) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE_YOU_CONTROL);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        new ExileTargetEffect(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC()), permanent.getIdName()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)).apply(game, source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        if (game.getState().getZone(permanent.getId()) != Zone.BATTLEFIELD) {
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DistributeCountersEffect(), false, "distribute X +1/+1 counters among any number of target creatures, where X is the exiled creature's power");
            ability.addTarget((Target)new TargetCreaturePermanentAmount(power, 0, power));
            game.fireReflexiveTriggeredAbility(ability, source);
        }
        return true;
    }
}

