/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.BlockedByOnlyOneCreatureThisCombatWatcher;

class YdwenEfreetEffect
extends OneShotEffect {
    YdwenEfreetEffect() {
        super(Outcome.Damage);
        this.staticText = "flip a coin. If you lose the flip, remove {this} from combat and it can't block. Creatures it was blocking that had become blocked by only {this} this combat become unblocked";
    }

    private YdwenEfreetEffect(YdwenEfreetEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(source.getSourceId());
        if (controller != null && creature != null) {
            if (!controller.flipCoin(source, game, true)) {
                Set combatGroups;
                creature.removeFromCombat(game);
                creature.setMaxBlocks(0);
                BlockedByOnlyOneCreatureThisCombatWatcher watcher = (BlockedByOnlyOneCreatureThisCombatWatcher)game.getState().getWatcher(BlockedByOnlyOneCreatureThisCombatWatcher.class);
                if (watcher != null && (combatGroups = watcher.getBlockedOnlyByCreature(creature.getId())) != null) {
                    for (CombatGroup combatGroup : combatGroups) {
                        if (combatGroup == null) continue;
                        combatGroup.setBlocked(false, game);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public YdwenEfreetEffect copy() {
        return new YdwenEfreetEffect(this);
    }
}

