/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class YggdrasilRebirthEngineReturnCreatureEffect
extends OneShotEffect {
    public YggdrasilRebirthEngineReturnCreatureEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put a creature card exiled with Yggdrasil onto the battlefield under your control. It gains haste until end of turn";
    }

    private YggdrasilRebirthEngineReturnCreatureEffect(YggdrasilRebirthEngineReturnCreatureEffect effect) {
        super((OneShotEffect)effect);
    }

    public YggdrasilRebirthEngineReturnCreatureEffect copy() {
        return new YggdrasilRebirthEngineReturnCreatureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        ExileZone exile = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exile == null || exile.isEmpty()) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile((FilterCard)StaticFilters.FILTER_CARD_CREATURE, exile.getId());
        target.withNotTarget(true);
        player.chooseTarget(this.outcome, (Cards)exile, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        if (!player.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            return false;
        }
        Permanent movedCard = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (movedCard == null) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(movedCard, game)), source);
        return true;
    }
}

