/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.common.CyclingDiscardCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.y.YidaroWanderingMonsterWatcher;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class YidaroWanderingMonsterEffect
extends OneShotEffect {
    YidaroWanderingMonsterEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle it into your library from your graveyard. If you've cycled a card named Yidaro, Wandering Monster four or more times this game, put it onto the battlefield from your graveyard instead.";
    }

    private YidaroWanderingMonsterEffect(YidaroWanderingMonsterEffect effect) {
        super((OneShotEffect)effect);
    }

    public YidaroWanderingMonsterEffect copy() {
        return new YidaroWanderingMonsterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Costs costs = (Costs)this.getValue("cycleCosts");
        if (costs == null) {
            return false;
        }
        MageObjectReference cycledCard = costs.stream().filter(CyclingDiscardCost.class::isInstance).map(CyclingDiscardCost.class::cast).map(CyclingDiscardCost::getCycledCard).findFirst().orElse(null);
        if (cycledCard == null || game.getState().getZone(cycledCard.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        Card card = cycledCard.getCard(game);
        if (card == null) {
            return false;
        }
        YidaroWanderingMonsterWatcher watcher = (YidaroWanderingMonsterWatcher)game.getState().getWatcher(YidaroWanderingMonsterWatcher.class);
        if (watcher == null || watcher.getYidaroCount(player.getId()) < 4) {
            player.putCardsOnBottomOfLibrary(card, game, source);
            player.shuffleLibrary(source, game);
        } else {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

