/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.keyword.CyclingAbility;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class YidaroWanderingMonsterWatcher
extends Watcher {
    private final Map<UUID, Integer> countMap = new HashMap<UUID, Integer>();

    YidaroWanderingMonsterWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ACTIVATED_ABILITY) {
            return;
        }
        StackObject object = game.getStack().getStackObject(event.getSourceId());
        if (object == null || !(object.getStackAbility() instanceof CyclingAbility)) {
            return;
        }
        Card card = game.getCard(object.getSourceId());
        if (card != null && "Yidaro, Wandering Monster".equals(card.getName())) {
            this.countMap.merge(object.getControllerId(), 1, Integer::sum);
        }
    }

    int getYidaroCount(UUID playerId) {
        return this.countMap.getOrDefault(playerId, 0);
    }
}

