/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class YuffieMateriaHunterEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.EQUIPMENT);

    YuffieMateriaHunterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may attach an Equipment you control to {this}";
    }

    private YuffieMateriaHunterEffect(YuffieMateriaHunterEffect effect) {
        super((OneShotEffect)effect);
    }

    public YuffieMateriaHunterEffect copy() {
        return new YuffieMateriaHunterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        return permanent.addAttachment(target.getFirstTarget(), source, game);
    }
}

