/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class YunasWhistleEffect
extends OneShotEffect {
    YunasWhistleEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal cards from the top of your library until you reveal a creature card. Put that card into your hand and the rest on the bottom of your library in a random order. When you reveal a creature card this way, put X +1/+1 counters on target creature you control, where X is the mana value of that card";
    }

    private YunasWhistleEffect(YunasWhistleEffect effect) {
        super((OneShotEffect)effect);
    }

    public YunasWhistleEffect copy() {
        return new YunasWhistleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card card = YunasWhistleEffect.getCard(player, (Cards)cards, game, source);
        player.revealCards(source, (Cards)cards, game);
        if (card == null) {
            return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        player.moveCards(card, Zone.HAND, source, game);
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(card.getManaValue())), false);
        ability.addTarget((Target)new TargetControlledCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    private static Card getCard(Player player, Cards cards, Game game, Ability source) {
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.isCreature(game)) continue;
            return card;
        }
        return null;
    }
}

