/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.TargetPointer;

enum TargetWasAttackingCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        TargetPointer target = source.getEffects().stream().map(Effect::getTargetPointer).filter(Objects::nonNull).findFirst().orElse(null);
        if (target == null) {
            return false;
        }
        Permanent creature = game.getPermanentOrLKIBattlefield(target.getFirst(game, source));
        if (creature == null) {
            return false;
        }
        return creature.isAttacking();
    }

    public String toString() {
        return "if it was attacking";
    }
}

