/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ZagrasThiefOfHeartbeatsTriggeredAbility
extends TriggeredAbilityImpl {
    ZagrasThiefOfHeartbeatsTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private ZagrasThiefOfHeartbeatsTriggeredAbility(ZagrasThiefOfHeartbeatsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ZagrasThiefOfHeartbeatsTriggeredAbility copy() {
        return new ZagrasThiefOfHeartbeatsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (permanent == null || !permanent.isCreature(game) || !permanent.isControlledBy(this.getControllerId())) {
            return false;
        }
        Permanent damaged = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (damaged == null || !permanent.isPlaneswalker(game)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new DestroyTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game)));
        return true;
    }

    public String getRule() {
        return "Whenever a creature you control deals combat damage to a planeswalker, destroy that planeswalker.";
    }
}

