/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.HashSet;
import java.util.Iterator;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;
import mage.util.RandomUtil;

class ZiatorasEnvoyEffect
extends OneShotEffect {
    ZiatorasEnvoyEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. You may play a land from the top of your library or cast a spell with mana value less than or equal to the damage dealt from the top of your library without paying its mana cost. If you don't, put that card into your hand";
    }

    private ZiatorasEnvoyEffect(ZiatorasEnvoyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZiatorasEnvoyEffect copy() {
        return new ZiatorasEnvoyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards("Top of your library", card, game);
        CardsImpl cards = new CardsImpl(card);
        if (player.canPlayLand()) {
            Card land;
            HashSet<Object> landSet = new HashSet<Object>();
            if (card instanceof ModalDoubleFacedCard) {
                ModalDoubleFacedCard mdfc = (ModalDoubleFacedCard)card;
                if (mdfc.getLeftHalfCard().isLand(game)) {
                    landSet.add(mdfc.getLeftHalfCard());
                }
                if (mdfc.getRightHalfCard().isLand(game)) {
                    landSet.add(mdfc.getRightHalfCard());
                }
            } else if (card.isLand(game)) {
                landSet.add(card);
            }
            if (!landSet.isEmpty() && player.chooseUse(Outcome.PutLandInPlay, "Play " + card.getName() + " as a land?", source, game)) {
                switch (landSet.size()) {
                    case 1: {
                        land = (Card)RandomUtil.randomFromCollection(landSet);
                        break;
                    }
                    case 2: {
                        Iterator iterator = landSet.iterator();
                        Card land1 = (Card)iterator.next();
                        Card land2 = (Card)iterator.next();
                        land = player.chooseUse(this.outcome, "Choose which land to play ", null, land1.getName(), land2.getName(), source, game) ? land1 : land2;
                        break;
                    }
                    default: {
                        land = null;
                        break;
                    }
                }
            } else {
                land = null;
            }
            if (land != null) {
                player.playLand(land, game, true);
            }
        }
        cards.retainZone(Zone.LIBRARY, game);
        if (cards.isEmpty()) {
            return true;
        }
        int damage = (Integer)this.getValue("damage");
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, damage + 1));
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filter);
        cards.retainZone(Zone.LIBRARY, game);
        return cards.isEmpty() || player.moveCards((Cards)cards, Zone.HAND, source, game);
    }
}

