/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ZilorthaApexOfIkoriaEffect
extends AsThoughEffectImpl {
    ZilorthaApexOfIkoriaEffect() {
        super(AsThoughEffectType.DAMAGE_NOT_BLOCKED, Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "for each non-Human creature you control, you may have that creature assign its combat damage as though it weren't blocked";
    }

    private ZilorthaApexOfIkoriaEffect(ZilorthaApexOfIkoriaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(sourceId);
        return controller != null && permanent != null && permanent.isControlledBy(controller.getId()) && !permanent.hasSubtype(SubType.HUMAN, game) && controller.chooseUse(Outcome.Damage, "Have " + permanent.getLogName() + " assign damage as though it weren't blocked?", source, game);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ZilorthaApexOfIkoriaEffect copy() {
        return new ZilorthaApexOfIkoriaEffect(this);
    }
}

