/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;

class ZilorthaStrengthIncarnateEffect
extends ContinuousEffectImpl {
    ZilorthaStrengthIncarnateEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Lethal damage dealt to creatures you control is determined by their power rather than their toughness";
    }

    private ZilorthaStrengthIncarnateEffect(ZilorthaStrengthIncarnateEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        FilterCreaturePermanent filter = StaticFilters.FILTER_PERMANENT_CREATURE.copy();
        filter.add((Predicate)new ControllerIdPredicate(source.getControllerId()));
        game.getState().addPowerInsteadOfToughnessForDamageLethalityFilter(source.getSourceId(), filter);
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }

    public ZilorthaStrengthIncarnateEffect copy() {
        return new ZilorthaStrengthIncarnateEffect(this);
    }
}

