/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class ZimoneMysteryUnravelerEffect
extends OneShotEffect {
    public ZimoneMysteryUnravelerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may turn a permanent you control face up";
    }

    protected ZimoneMysteryUnravelerEffect(ZimoneMysteryUnravelerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZimoneMysteryUnravelerEffect copy() {
        return new ZimoneMysteryUnravelerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        FilterControlledPermanent filter = new FilterControlledPermanent("a permanent you control");
        filter.add((Predicate)FaceDownPredicate.instance);
        if (controller != null) {
            TargetControlledPermanent target = new TargetControlledPermanent(0, 1, filter, true);
            controller.choose(Outcome.BoostCreature, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            return permanent != null && permanent.turnFaceUp(source, game, source.getControllerId());
        }
        return false;
    }
}

