/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ZimoneParadoxSculptorEffect
extends OneShotEffect {
    ZimoneParadoxSculptorEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the number of each kind of counter on up to two target creatures and/or artifacts you control";
    }

    private ZimoneParadoxSculptorEffect(ZimoneParadoxSculptorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZimoneParadoxSculptorEffect copy() {
        return new ZimoneParadoxSculptorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            for (Counter counter : permanent.getCounters(game).values()) {
                Counter newCounter = new Counter(counter.getName(), counter.getCount());
                permanent.addCounters(newCounter, source.getControllerId(), source, game);
            }
        }
        return true;
    }
}

