/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.choices.ChooseFriendsAndFoes;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ZndrspltsJudgmentEffect
extends OneShotEffect {
    ZndrspltsJudgmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each player, choose friend or foe. Each friend creates a token that's a copy of a creature they control. Each foe returns a creature they control to its owner's hand";
    }

    private ZndrspltsJudgmentEffect(ZndrspltsJudgmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZndrspltsJudgmentEffect copy() {
        return new ZndrspltsJudgmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenCopyTargetEffect effect;
        TargetPermanent target;
        FilterCreaturePermanent filter;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ChooseFriendsAndFoes choice = new ChooseFriendsAndFoes();
        choice.chooseFriendOrFoe(controller, source, game);
        for (Player player : choice.getFriends()) {
            if (player == null) continue;
            filter = new FilterCreaturePermanent("creature you control");
            filter.add((Predicate)new ControllerIdPredicate(player.getId()));
            target = new TargetPermanent((FilterPermanent)filter);
            target.withNotTarget(true);
            if (!player.choose(Outcome.Copy, (Target)target, source, game)) continue;
            effect = new CreateTokenCopyTargetEffect(player.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
            effect.apply(game, source);
        }
        for (Player player : choice.getFoes()) {
            filter = new FilterCreaturePermanent("creature you control");
            filter.add((Predicate)new ControllerIdPredicate(player.getId()));
            target = new TargetPermanent((FilterPermanent)filter);
            target.withNotTarget(true);
            if (!player.choose(Outcome.ReturnToHand, (Target)target, source, game)) continue;
            effect = new ReturnToHandTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
            effect.apply(game, source);
        }
        return true;
    }
}

